sub Init()
    mBind(["posterMask", "itemPoster", "itemMask", "posterText", "groupStar", "posterStar", "background"])
    m.posterText.font = createFont(getTheme().regularFont, 22)
end sub

sub OnItemContentChange()
    itemContent = m.top.itemContent
    if itemContent = invalid then return
    m.itemPoster.uri = itemContent.HDPOSTERURL
    m.posterText.text = itemContent.title
	itemPoster = m.itemPoster.boundingRect()
	itemlabel = m.posterText.boundingRect()
	centerY = (itemPoster.width - itemlabel.width) / 2
	m.posterText.translation = [centery, 0]
    m.rating = Int(evalFloat(itemContent.rating)) / 2
	m.posterStar.width =  m.groupStar.boundingRect().width + 50
	m.posterStar.translation = [(itemPoster.width - m.posterStar.width) / 2, 5]
	m.groupStar.translation = [((itemPoster.width - m.groupStar.boundingRect().width) / 2) + 18, 11]
	updateStars()
end sub

'
'Use FocusPercent to animate scaling of Poser Image
sub focusChanging() 
    scaleFactor = 0.85 + (m.top.focusPercent * 0.08)
    m.posterMask.scale = [scaleFactor, scaleFactor]
	'm.itemmask.opacity = 0.75 - (m.top.focusPercent * 0.75)
end sub

sub updateStars()
    for i = 1 to 5
        star = m.top.findNode("star" + i.tostr())
        if m.rating >= i then
            star.uri = "pkg:/images/icons/star_full.png"
        elseif m.rating >= i - 0.5 then
            star.uri = "pkg:/images/icons/star_half.png"
        else
            star.uri = "pkg:/images/icons/star_empty.png"
        end if
    end for
end sub

function on_focus_change(event as object) as void
    if event.getData()
        m.posterText.repeatCount = -1
    else
        m.posterText.repeatCount = 0
    end if
end function



