'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
' entry point of detailsScreen
sub Init()
    mBind(["title", "poster"])
    m.poster.ObserveField("loadStatus", "OnPosterLoadStatusChanged")
    m.top.ObserveField("content","OnContentSet")
    m.top.ObserveField("width","OnLayoutChanged")
    m.top.ObserveField("height","OnLayoutChanged")
    m.horizontalMargin = 5
    m.verticalMargin = 7
    'm.title.translation = [m.horizontalMargin * 25, m.verticalMargin]
    'm.poster.translation = [0, m.verticalMargin * 2]
end sub

sub OnContentSet()
    content = m.top.content
    if content <> invalid
	    title = content.title
        'if title.len() >= 14 title = left(title, 14)+"..."
        m.title.text = title
        m.poster.uri = content.HDPOSTERURL
    end if
end sub

sub OnLayoutChanged()
    renderingWidth = m.top.width - m.horizontalMargin * 2
    renderingHeight = m.top.height - m.verticalMargin * 2
	
    m.poster.width = renderingWidth /6
    m.poster.height = renderingHeight - 20
    m.poster.loadWidth = renderingWidth /6
    m.poster.loadheight = renderingHeight - 20
	
	m.title.maxWidth = renderingWidth - 100
    m.title.height = renderingHeight
	
	m.poster.translation = [0, (renderingHeight - m.poster.height) / 2]
	m.title.translation = [0, (renderingHeight - m.poster.height) / 2 + 10]
end sub

sub OnPosterLoadStatusChanged(event as Object)
    loadStatus = event.getData()
    if loadStatus = "ready"
        'm.title.visible = false
    end if
end sub

function on_focus_change(event as object) as void
    ?"focus_change ";event.getData()
    if event.getData()
        'm.posterText.repeatCount = -1
    else
        'm.posterText.repeatCount = 0
    end if
end function

