'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub Init()
    mBind(["loadingIndicator", "overhang", "clock", "timeServer"])
	
    m.top.backgroundColor = getTheme().backgroundColor
    m.top.backgroundUri = getTheme().backgroundURI

    InitScreenStack()
	go()
	m.clock.observeField("fire","updateTime")
	m.timeServer.observeField("fire", "serverTime")
	
	m.loadingIndicator.width = getScreenSize().width
	m.loadingIndicator.height = getScreenSize().height
end sub

sub serverTime()
	m.global.timeServer = m.global.timeServer + 1
	'Dbg("Time Server ", m.global.timeServer)
end sub

sub go()
    'Dbg("Run GO")    
    m.confirm = createObject("roSGNode", "ConfirmUserTask")
    m.confirm.control = "RUN"
    m.confirm.observeField("state", "done") 
end sub

sub done()
    'Dbg("Run Done")
    if m.confirm.state = "stop" then
        if m.confirm.auth = "1" then
	        m.timeServer.repeat = true
            m.timeServer.control = "start"
	        m.clock.repeat = true
            m.clock.control = "start"
            if m.confirm.status = "Disabled" then
		        m.clock.repeat = false
                m.clock.control = "stop"
				WarningScreenLogic("Disabled")
				m.global.isExitApp = true
            else if m.confirm.status = "Banned" then
		        m.clock.repeat = false
                m.clock.control = "stop"
                WarningScreenLogic("Banned")
				m.global.isExitApp = true
            else if m.confirm.status = "Expired" then
		        m.clock.repeat = false
                m.clock.control = "stop"
                WarningScreenLogic("Expired")
				m.global.isExitApp = true
            else if m.confirm.status = "Active" then
                ShowMenuScreen()
				m.global.isExitApp = false
            end if   
        else
            ShowLoginScreen()
        end if
    end if
end sub

sub updateTime()
	Dbg("Update Time")
	m.clock.duration = 300
    m.checkAuth = createObject("roSGNode", "ConfirmUserTask")
    m.checkAuth.control = "RUN"
    m.checkAuth.observeField("state", "onCheckAuth") 
end sub

function onCheckAuth()
    if m.checkAuth.state = "stop" then
        if m.checkAuth.auth = "1" then
            if m.checkAuth.status = "Disabled" and not m.global.isExitApp = true then
		        'm.clock.repeat = false
                'm.clock.control = "stop"
				WarningScreenLogic("Disabled")
				m.global.isExitApp = true
            else if m.checkAuth.status = "Banned" and not m.global.isExitApp = true then
		        'm.clock.repeat = false
                'm.clock.control = "stop"
                WarningScreenLogic("Banned")
				m.global.isExitApp = true
            else if m.checkAuth.status = "Expired" and not m.global.isExitApp = true then
		        'm.clock.repeat = false
                'm.clock.control = "stop"
                WarningScreenLogic("Expired")
				m.global.isExitApp = true
            else if m.checkAuth.status = "Active" and m.global.isExitApp = true then
				CloseScreen(invalid)
				m.global.isExitApp = false
            end if  
        else
            ShowLoginScreen()
        end if
    end if
end function

sub showExitApp()
    dialog = createObject("roSGNode", "Dialog")
    dialog.message = tr("Are you sure you want to exit?")
    dialog.buttons = [tr("Exit"), tr("Cancel")]
    dialog.observeField("buttonSelected", "ButtonSelectedExit")
    m.top.dialog = dialog
end sub

sub ButtonSelectedExit()
    if m.top.dialog.buttonSelected = 0
        m.top.close = true
    else
        m.top.dialog.close = true
    end if
end sub

sub showExitButton()
    m.top.dialog.close = true
end sub

' The OnKeyEvent() function receives remote control key events
function OnkeyEvent(key as String, press as Boolean) as Boolean
    result = false
    if press
        ' handle "back" key press
        if key = "back"
            numberOfScreens = m.screenStack.Count()
			Dbg("Back",numberOfScreens)
			if numberOfScreens <> 3 and numberOfScreens <> 4 and numberOfScreens <> 5 and numberOfScreens <> 6
			   getScene().FindNode("overhang").visible = true
			   m.top.backgroundUri = getTheme().backgroundURI
			   if m.global.contentTask <> invalid
			       m.global.contentTask.control = "stop" 
			   end if 
			end if 
            if numberOfScreens > 1 and not m.global.isExitApp then
                CloseScreen(invalid)
                result = true
			else
			    showExitApp()
                result = true
            end if
        end if
    end if
    ' The OnKeyEvent() function must return true if the component handled the event,
    ' or false if it did not handle the event.
    return result
end function