'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub ShowEpisodesScreen(content as Object, selectedItem as Integer)
    ' create instance of the EpisodesScreen
    m.episodesScreen = CreateObject("roSGNode", "EpisodesScreen")
    ' observe selectedItem field so we can know which episode is selected
    m.episodesScreen.ObserveField("selectedItem", "OnEpisodesScreenItemSelected")
    ' populate episodeScreen with content based on which serial was chosen
    m.episodesScreen.content = content.GetChild(selectedItem)
    ShowScreen(m.episodesScreen)
end sub

sub OnEpisodesScreenItemSelected(event as Object)
    episodes = event.GetRoSGNode()
    ' extract the row and column indexes of the item the user selected
    selectedIndex = event.GetData()
    ' the entire row from the EpisodesScreen will be used by the DetailsScreen
    rowContent = episodes.content.GetChild(selectedIndex[0])
    'ShowDetailsScreen(rowContent, selectedIndex[1])
	ShowVideoScreen(rowContent, selectedIndex[1], true)
	m.selectedIndex = m.episodesScreen.jumpToEpisode 
end sub