'*************************************************************
'** Roku Xtream-ALL for XoceUnder                            *
'** Copyright (c)2024 XoceUnder.  All rights reserved.       *
'*************************************************************
sub ShowGridScreen()
    m.GridScreen = CreateObject("roSGNode", "GridScreen")
    m.GridScreen.ObserveField("itemSelected", "OnGridScreenItemSelected")
    m.GridScreen.ObserveField("itemSelectedFilter", "OnGridScreenItemSelected")
	m.GridScreen.ObserveField("categorySelected", "OnMenuSelected")
	m.GridScreen.ObserveField("keyboardText", "OnKeyboardChanged")
    ShowScreen(m.GridScreen) ' show GridScreen
	m.GridScreen.screenlabel = CapitalizeFirstLetter(m.global.titleSection)
end sub


sub OnMenuSelected(event as Object)
    m.GridScreen.content = invalid
    grid = event.GetRoSGNode()
	m.index = grid.category.GetChild(event.GetData())
	if m.index.look <> 0
        m.look = createObject("roSGNode", "PinDialog")
        m.look.title = "Enter Pin"
		if regread("lock", ReadManifest().title) = "0000" then m.look.message = tr("Default pin is 0000 to change it in account settings")
        m.look.observeField("pin","onVerifyPin")
        m.look.setFocus(true)
        m.top.dialog = m.look
	else
        m.movieTask = CreateObject("roSGNode", "MainLoaderTask")
        m.movieTask.ObserveField("content", "OnMovieContentLoaded")
        m.movieTask.category_id = m.index.id
        m.movieTask.category_title = m.index.title
        m.movieTask.control = "run"
        m.loadingIndicator.visible = true
	end if
end sub

sub onVerifyPin()
	if m.look.pin.len() = 4 then
       'print "ok button pressed"
        m.confirmPin = createObject("roSGNode", "PinTask")
        m.confirmPin.section = ReadManifest().title
        m.confirmPin.pin = m.look.pin
        m.confirmPin.observeField("state","showAdults")
        m.confirmPin.control = "RUN"
    end if
end sub

sub showAdults()
    if m.confirmPin.state = "stop" then 
        if m.confirmPin.result then
		    m.look.close = true
            m.movieTask = CreateObject("roSGNode", "MainLoaderTask")
            m.movieTask.ObserveField("content", "OnMovieContentLoaded")
            m.movieTask.category_id = m.index.id
            m.movieTask.category_title = m.index.title
            m.movieTask.control = "run"
            m.loadingIndicator.visible = true
        else
            m.look.title = "Incorrect Pin, try again"
            m.look.pin = ""
			m.look.setFocus(true)
        end if
    end if
end sub

sub OnMovieContentLoaded()
    m.GridScreen.content = invalid
	m.GridScreen.searchContent = invalid
	getScene().FindNode("filteredList").visible = false
	getScene().FindNode("markupGrid").visible = true
    m.GridScreen.SetFocus(true)
    m.loadingIndicator.visible = false
    m.GridScreen.content = m.movieTask.content 
end sub

sub OnKeyboardChanged(event as Object)
    searchText = event.GetData()
	grid = event.GetRoSGNode()
	if grid.content <> invalid then
    	m.searchContent = grid.content.Clone(true)
    	if m.searchContent.getChildCount() <> 0 then
    	    filteredContent = searchContent(m.searchContent, searchText)
            if filteredContent <> invalid
    		    getScene().FindNode("markupGrid").visible = false
			    'getScene().FindNode("markupGrid").setFocus(false)
		        'getScene().FindNode("filteredList").setFocus(true)
		        getScene().FindNode("filteredList").visible = true
                m.GridScreen.searchContent = filteredContent	
            end if
	    end if
	end if
end sub

sub OnGridScreenItemSelected(event as Object)
    grid = event.GetRoSGNode()
    ' extract the row and column indexes of the item the user selected
    m.selectedIndex = event.GetData()
    ' the entire row from the RowList will be used by the Video node
	if getScene().FindNode("filteredList").visible then
        rowContent = grid.searchContent.Clone(true)
	else
        rowContent = grid.content.Clone(true)	
	end if
    m.selectedRow = m.selectedIndex
    ShowDetailsScreen(rowContent, m.selectedIndex)
end sub

function searchContent(content as Object, searchTerm as String) as Object
    searchResults = []
    for each item in content.GetChildren(- 1, 0)
		if instr(1, LCase(item.title), searchTerm) <> 0 then
            searchResults.push(item)
        end if
    end for
    contentNode = CreateObject("roSGNode", "ContentNode")
    contentNode.Update({children: searchResults}, true)
    return contentNode
end function