'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub ShowLoginScreen()
    m.LoginScreen = CreateObject("roSGNode", "LoginScreen")
	m.LoginScreen.ObserveField("success","ShowLoginMenuScreen")
	m.LoginScreen.observeField("status", "LoginDone")
    server = CreateObject("roSGNode", "GetServerTask")
    server.ObserveField("servers", "OnServerLoaded")
	server.ObserveField("response", "OnServerResponse")
    server.control = "run"
	m.loadingIndicator.visible = true
end sub

sub OnServerResponse(event as Object)
	'Dbg("Response Server ", event.GetData())
	json = event.GetData()
    if json <> invalid then
        dialog = createObject("roSGNode", "Dialog")
        dialog.title = json[0].status+" !"
        dialog.optionsDialog = true
		dialog.buttons = [tr("OK")]
        dialog.message = json[0].error
        'm.dialog.observeField("buttonSelected", "ButtonSelectedExit")
        getScene().dialog = dialog
    end if
end sub

sub OnServerLoaded(event as Object)
	'Dbg("Show Server ", event.GetData())
    data = CreateObject("roSGNode", "ContentNode")
    items = event.GetData()
	for i = 0 to items.count()-1
        item = data.CreateChild("ServerListNode")
		item.update({"index": i}, true)
        item.title = items[i].dns_title
        item.url = items[i].dns_base
    end for
	m.LoginScreen.content = data
	m.loadingIndicator.visible = false	
	ShowScreen(m.LoginScreen) ' show LoginScreen
end sub

sub LoginDone()
    'Dbg("Validate Login Done", m.LoginScreen.status)
    if m.LoginScreen.status = "Disabled" then
		WarningScreenLogic("Disabled")
		m.global.isExitApp = true
    else if m.LoginScreen.status = "Banned" then
        WarningScreenLogic("Banned")
		m.global.isExitApp = true
    else if m.LoginScreen.status = "Expired" then
        WarningScreenLogic("Expired")
		m.global.isExitApp = true
    else if m.LoginScreen.status = "Active" then
	    m.LoginScreen.success = true
		m.global.isExitApp = false
		'getScene().backgroundColor = getTheme().backgroundColor
		'getScene().backgroundUri = "pkg:/images/bg-main.jpg"
    end if 
end sub

sub ShowLoginMenuScreen(event as Object)
	Dbg("Show Menu ", event.GetData())
    if event.GetData() <> invalid then
        m.dialog = createObject("roSGNode", "Dialog")
        m.dialog.title = tr("Congratulations!")
        m.dialog.optionsDialog = true
		m.dialog.buttons = [tr("OK")]
        m.dialog.message = tr("You have successfully linked your Roku player to your account")
        m.dialog.observeField("buttonSelected", "showExitButton")
        getScene().dialog = m.dialog
    end if
	CloseScreen(m.LoginScreen)
	ShowMenuScreen()
	getScene().FindNode("clock").repeat = true
    getScene().FindNode("clock").control = "start"
end sub

