'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub ShowMenuScreen()
    m.MenuScreen = CreateObject("roSGNode", "MenuScreen")
    m.MenuScreen.observeField("itemFocused", "OnMenuFocused") 
	m.MenuScreen.observeField("itemSelected", "OnMenuSelection")
    ShowScreen(m.MenuScreen) ' show MenuScreen
end sub

Sub OnMenuFocused(event as Object)

    'Item focused
    grid = event.GetRoSGNode()
	focusedItem = grid.content.getChild(event.GetData())
    getScene().FindNode("itemLabelMain1").text = focusedItem.shortdescriptionline1
    getScene().FindNode("itemLabelMain1").height = getScreenSize().height
	getScene().FindNode("itemLabelMain1").width = getScreenSize().width

    getScene().FindNode("itemLabelMain2").text = focusedItem.shortdescriptionline2
    getScene().FindNode("itemLabelMain2").height = getScreenSize().height
	getScene().FindNode("itemLabelMain2").width = getScreenSize().width
	
End Sub

sub OnMenuSelection(event)
  itemSelected = event.getData()
  Dbg("Menu item:", itemSelected)
  if itemSelected <> invalid
	' Menu Buscador    
    if itemSelected = 0
	   ShowSearchScreen()  
	' Menu Live  
    else if itemSelected = 1
	   m.global.contentType =  "live"
	   m.global.titleSection =  tr("live")
	   m.global.action = "get_live_categories"
	   m.global.items =  "get_live_streams"
	   m.global.play = "/live/" + m.global.user + "/" + m.global.pass + "/"
	   m.global.isAdult = false
	   ShowTimeGridScreen()
       RunCategoryTask() ' retrieving content
	' Menu Movie  
    else if itemSelected = 2
	   m.global.contentType =  "movie"
	   m.global.titleSection =  tr("movies")
	   m.global.action = "get_vod_categories"
	   m.global.items =  "get_vod_streams"
	   m.global.play = "/movie/" + m.global.user + "/" + m.global.pass + "/"
	   ShowGridScreen()
       RunCategoryTask() ' retrieving content
	' Menu Serie  
    else if itemSelected = 3
	   m.global.contentType =  "series"
	   m.global.titleSection =  tr("series")
	   m.global.action = "get_series_categories"
	   m.global.items =  "get_series"
	   m.global.play = "/series/" + m.global.user + "/" + m.global.pass + "/"
	   ShowGridScreen()
       RunCategoryTask() ' retrieving content
	' Menu Account  
    else if itemSelected = 4
	    currDialog = createObject("roSGNode", "AccountScreenDialog")
        currDialog.id = "AccountScreen"
		m.top.dialog = currDialog
	' Menu My List  
    else if itemSelected = 5
	   m.global.titleSection =  tr("My Favorites")
	   ShowMyListScreen()
       RunMyListTask() ' retrieving content
	' Menu Setting  
    else if itemSelected = 6
	    if regread("lock", ReadManifest().title) = "0000" then
	       ShowSettingScreen()
		else
            m.look = createObject("roSGNode", "PinDialog")
            m.look.title = tr("Enter Pin")
            m.look.pinPad.secureMode  = false
            m.look.pinPad.pinLength   = "4"
            'm.look.buttons = [tr("OK")]
			'm.lock.optionsDialog = true
            m.look.observeField("pin","onVerifyAccess")
            m.look.setFocus(true)
            getScene().dialog = m.look
	    end if
    end if
  end if
end sub

sub onVerifyAccess()
	if m.look.pin.len() = 4 then
       'print "ok button pressed"
        m.confirmPin = createObject("roSGNode", "PinTask")
        m.confirmPin.section = ReadManifest().title
        m.confirmPin.pin = m.look.pin
        m.confirmPin.observeField("state","verifyAccess")
        m.confirmPin.control = "RUN"
    end if
end sub

sub verifyAccess()
    if m.confirmPin.state = "stop" then 
        if m.confirmPin.result then
		    getScene().dialog.close = true
		    ShowSettingScreen()
        else
            m.look.title = tr("Incorrect Pin, try again")
            m.look.pin = ""
			m.look.setFocus(true)
        end if
    end if
end sub

sub OnGridScreenItem(event as Object)
    focusedIndex = event.GetRoSGNode().rowItemSelected
	m.row = focusedIndex[0]
	m.column = focusedIndex[1]
    ' extract the row and column indexes of the item the user selected
    m.selectedIndex = event.GetData()
    ' the entire row from the RowList will be used by the Video node
    rowContent = getScene().FindNode("rowList").content.GetChild(m.row)
    m.selectedRow = m.row
    ShowDetailsScreen(rowContent, m.column)
end sub

