'*************************************************************
'** Roku Xtream-ALL for XoceUnder                            *
'** Copyright (c)2024 XoceUnder.  All rights reserved.       *
'*************************************************************
sub ShowMyListScreen()
    m.MyListScreen = CreateObject("roSGNode", "MyListScreen")
    m.MyListScreen.ObserveField("itemSelected", "OnMyListScreenItemSelected")
    ShowScreen(m.MyListScreen) ' show GridScreen
	m.MyListScreen.screenlabel = CapitalizeFirstLetter(m.global.titleSection)
end sub

sub OnMyListScreenItemSelected(event as Object)
    grid = event.GetRoSGNode()
    ' extract the row and column indexes of the item the user selected
    m.selectedIndex = event.GetData()
    ' the entire row from the RowList will be used by the Video node
    rowContent = grid.content.Clone(true)	
    m.selectedRow = m.selectedIndex
	info = rowContent.GetChild(m.selectedIndex)
	if info.mediaType = "live"
	    ShowVideoLiveScreen(rowContent, m.selectedIndex)
	else
	    ShowDetailsScreen(rowContent, m.selectedIndex)
	end if
end sub
