' ********** Copyright 2020 Roku Corp.  All Rights Reserved. **********

' Note that we need to import this file in MainScene.xml using relative path.

sub ShowSearchScreen()
    m.SearchScreen = CreateObject("roSGNode", "SearchScreen")
	m.SearchScreen.ObserveField("rowItemSelected", "OnSearchScreenItemSelected")
    'm.SearchScreen.ObserveField("currentText", "OnKeyboardInputsTextChanged")
    ShowScreen(m.SearchScreen) ' show GridScreen
end sub

sub OnSearchScreenItemSelected(event as Object)
    grid = event.GetRoSGNode()
    ' extract the row and column indexes of the item the user selected
    m.selectedIndex = event.GetData()
    ' the entire row from the RowList will be used by the Video node
    rowContent = grid.content.GetChild(m.selectedIndex[0])
    m.selectedRow = m.selectedIndex[0]
	info = rowContent.GetChild(m.selectedIndex[1])
	if info.mediaType = "live"
	    ShowVideoLiveScreen(rowContent, m.selectedIndex[1])
	else
	    ShowDetailsScreen(rowContent, m.selectedIndex[1])
	end if
end sub
