'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub ShowTimeGridScreen()
    m.GridScreen = CreateObject("roSGNode", "TimeGridView")
	m.GridScreen.ObserveField("categorySelected", "OnCategorySelected")
	m.GridScreen.observeField("categoryFocused", "onCategoryFocused")
	'm.GridScreen.observeField("pin", "confirmPin")
    ShowScreen(m.GridScreen) ' show TimeGridView
	m.loadingIndicator.visible = true
end sub

sub onCategoryFocused(event)
	m.top.getscene().FindNode("avisoFav").opacity = 0
	m.top.getscene().FindNode("TimerFav").control = "stop"
    grid = event.GetRoSGNode()
    selectedIndex = event.GetData()
	if selectedIndex > -1 and m.GridScreen.content = invalid
		item = grid.category.GetChild(event.GetData())
		if item.look
        	m.look = createObject("roSGNode", "PinDialog")
        	m.look.title = tr("Enter Pin")
			if regread("lock", ReadManifest().title) = "0000" then m.look.message = tr("Default pin is 0000 to change it in account settings")
        	m.look.observeField("pin","confirmPinLook")
        	m.look.setFocus(true)
        	getScene().dialog = m.look
		else
		    ShowSpinner(true)
        	m.TimeGrid = CreateObject("roSGNode", "TimeGridLoaderTask")
        	m.TimeGrid.ObserveField("content", "OnTimeGridContentLoaded")
	    	m.TimeGrid.id =  item.id
        	m.TimeGrid.control = "run"
		end if
		
	end if
end sub

sub OnCategorySelected(event as Object)
	m.top.getscene().FindNode("avisoFav").opacity = 0
	m.top.getscene().FindNode("TimerFav").control = "stop"
    grid = event.GetRoSGNode()
	item = grid.category.GetChild(event.GetData())
	m.catID = item.id
	if m.global.contentTask <> invalid 
	    m.global.contentTask.control = "stop" 
	end if 
	if item.look
        m.look = createObject("roSGNode", "PinDialog")
        m.look.title = tr("Enter Pin")
		if regread("lock", ReadManifest().title) = "0000" then m.look.message = tr("Default pin is 0000 to change it in account settings")
        m.look.observeField("pin","confirmPinLook")
        m.look.setFocus(true)
        getScene().dialog = m.look
	else
	    ShowSpinner(true)
        m.TimeGrid = CreateObject("roSGNode", "TimeGridLoaderTask")
        m.TimeGrid.ObserveField("content", "OnTimeGridContentLoaded")
	    m.TimeGrid.id =  m.catID
        m.TimeGrid.control = "run"
	end if
end sub

sub OnTimeGridContentLoaded(event as Object)
    m.loadingIndicator.visible = false
    content = event.getData()
    m.top.getscene().FindNode("GroupGuia").visible = true
    ShowSpinner(false)
    m.GridScreen.SetFocus(true)
    m.GridScreen.content = content
	m.GridScreen.callFunc("collapseMenu")
	if content.GetChildCount() <> 0
        m.global.contentTask = CreateObject("roSGNode", "epgLoaderTask")
	    m.global.contentTask.content = m.GridScreen.content
        m.global.contentTask.control = "run"
	end if
end sub

sub confirmPinLook() 
    if m.look.pin.len() = 4 then
	    m.confirmPin = createObject("roSGNode", "PinTask")
        m.confirmPin.section = ReadManifest().title
        m.confirmPin.pin = m.look.pin
        m.confirmPin.observeField("state","showAdultsLook")
        m.confirmPin.control = "RUN"
    end if
end sub

sub showAdultsLook()
    if m.confirmPin.state = "stop" then 
        if m.confirmPin.result then
		    ShowSpinner(true)
		    getScene().dialog.close = true
            m.TimeGrid = CreateObject("roSGNode", "TimeGridLoaderTask")
            m.TimeGrid.ObserveField("content", "OnTimeGridContentLoaded")
	        m.TimeGrid.id =  m.catID
            m.TimeGrid.control = "run"
        else
            m.look.title = tr("Incorrect Pin, try again")
            m.look.pin = ""
			m.look.setFocus(true)
        end if
    end if
end sub

sub ShowSpinner(show)
	m.top.getscene().FindNode("spinner").visible = show
    if show
        m.top.getscene().FindNode("spinner").control = "start"
    else
        m.top.getscene().FindNode("spinner").control = "stop"
    end if
end sub