'*************************************************************
'** Roku Xtream-ALL for XoceUnder                            *
'** Copyright (c)2024 XoceUnder.  All rights reserved.       *
'*************************************************************
sub ShowVideoScreen(rowContent as Object, selectedItem as Integer, isSeries = false as Boolean)
    m.isSeries = isSeries
    m.videoPlayer = CreateObject("roSGNode", "VideoPlayer") ' create new instance of video node for each playback
	if isSeries
         if selectedItem <> 0 ' check if user select any but first item of the row
            childrenClone = CloneChildren(rowContent, selectedItem)
            ' create new parent node for our cloned items
            rowNode = CreateObject("roSGNode", "ContentNode")
            rowNode.Update({ children: childrenClone }, true)
            m.videoPlayer.content = rowNode ' set node with children to video node content
        else
            ' if playback must start from first item we clone all row node
            m.videoPlayer.content = rowContent.Clone(true)
        end if
		?"Info ";m.videoPlayer.content.GetChild(0)
		m.id = m.videoPlayer.content.GetChild(0).id
		m.length = m.videoPlayer.content.GetChild(0).length
		m.videoPlayer.contentIsPlaylist = true ' enable video playlist (a sequence of videos to be played)
	else
	    
	    m.videoPlayer.content = rowContent.GetChild(selectedItem)
	    m.id = m.videoPlayer.content.id
		m.length = m.videoPlayer.content.length
	end if	
	
    ?m.videoPlayer.content
    m.resume = createObject("roSGNode", "ResumeVideo")
    m.resume.section = "VideoPosition"
    m.resume.id = m.id
    m.resume.control = "RUN"
    m.resume.observeField("state","resume")
	
    m.videoPlayer.ObserveField("visible", "OnVideoVisibleChange")
    m.videoPlayer.ObserveField("closeVideo", "OnVideoScreenClose")

end sub

sub OnVideoScreenClose(event as Object) ' invoked once videoScreen's close field is changed
    videoScreen = event.GetRoSGNode()
    close = event.GetData()
    if close = true
	    m.videoPlayer.control = "stop" ' stop playback
        CloseScreen(videoScreen) ' remove videoScreen from scene and close it
        screen = GetCurrentScreen()
        screen.SetFocus(true) ' return focus to DetailsScreen
        ' in case of series we shouldn't change focus on DetailsScreen
        if m.isSeries = false
            screen.jumpToItem = m.selectedIndex
        end if
    end if
end sub

sub OnVideoVisibleChange() ' invoked when video node visibility is changed
    if m.videoPlayer.visible = false and m.top.visible = true
        ' the index of the video in the video playlist that is currently playing.
        currentIndex = m.videoPlayer.contentIndex
        m.videoPlayer.control = "stop" ' stop playback
        'clear video player content, for proper start of next video player
        m.videoPlayer.content = invalid
        screen = GetCurrentScreen()
        screen.SetFocus(true) ' return focus to details screen
        newIndex = m.selectedIndex
        if m.isSeries = true
           m.isSeries = false
        else
           newIndex += currentIndex
        end if
        ' navigate to the last played item
        screen.jumpToItem = newIndex
    end if
end sub

sub resume()
    if m.resume.state = "stop"
        if m.resume.pos >= 60 and m.resume.pos < (m.length * 0.9) then
            m.dialog = createObject("roSGNode", "Dialog")
            m.dialog.title = "Resume"
            m.dialog.optionsDialog = true
            resumePos = "Continue " + GetDurationStringStandard(m.resume.pos)
            m.dialog.buttons = [resumePos,"Restart"]  
            m.top.getScene().dialog = m.dialog
            m.dialog.observeField("buttonSelected","resumeSelected")
        else
            ShowScreen(m.videoPlayer) ' show video screen
            m.videoPlayer.control = "play" ' start playback
        end if
    end if
end sub

sub resumeSelected()
    if m.dialog.buttonSelected = 0 then
        ShowScreen(m.videoPlayer) ' show video screen
	    m.videoPlayer.seek = m.resume.pos
        m.videoPlayer.control = "play" ' start playback
    else
        ShowScreen(m.videoPlayer) ' show video screen
        m.videoPlayer.control = "play" ' start playback
    end if
    m.dialog.close = true
end sub 
