sub init()

    mBind(["LoginBox", "grp", "label", "userTextEditBox","passTextEditBox", "loginButton", 
	       "keyBox", "userKeyboard", "passKeyboard", "showAnimation", "hideAnimation","showKey",
		   "hideKey", "userEditBox", "passEditBox", "serverList"])

    m.fullWidth = getScreenSize().width
    m.fullHeight = getScreenSize().height
    
    m.rectWidth = m.fullWidth * 0.5
    m.rectHeight = m.fullHeight * 0.5
	

    m.grp.translation = [0, 70]
	
    m.LoginBox.width = m.rectWidth
    m.LoginBox.height = m.rectHeight + 150
    m.LoginBox.translation = [m.fullWidth / 2 - m.LoginBox.width / 2 , m.fullHeight / 2 - m.LoginBox.height / 2]
	
	m.label.fontSize = (m.rectHeight / 8)
	m.label.translation = [m.rectWidth / 2 - m.label.boundingRect().width / 2, 0]
	
	m.label.text = tr("Login to your Account:")
	m.userTextEditBox.hintText = tr(" Username")
	m.passTextEditBox.hintText = tr(" Password")
	m.loginButton.text = tr("Login")
	m.loginButton.minWidth  = (m.fullWidth / 2.5)
	
	m.userTextEditBox.width  = (m.fullWidth / 2.5)
	m.userTextEditBox.height  = m.loginButton.boundingRect().height
	m.userTextEditBox.translation = [m.rectWidth / 2 - m.userTextEditBox.boundingRect().width / 2 , 0]
	m.userTextEditBox.maxTextLength  = 15
	
	m.userEditBox.width  = (m.fullWidth / 2.5)
	m.userEditBox.height  = m.loginButton.boundingRect().height
	m.userEditBox.translation = [m.rectWidth / 2 - m.userTextEditBox.boundingRect().width / 2 , 0]
	
	m.passTextEditBox.width  = (m.fullWidth / 2.5)
	m.passTextEditBox.height  = m.loginButton.boundingRect().height
	m.passTextEditBox.translation = [m.rectWidth / 2 - m.passTextEditBox.boundingRect().width / 2, 0]
	m.passTextEditBox.maxTextLength  = 15
	
	m.passEditBox.width  = (m.fullWidth / 2.5)
	m.passEditBox.height  = m.loginButton.boundingRect().height
	m.passEditBox.translation = [m.rectWidth / 2 - m.passTextEditBox.boundingRect().width / 2, 0]
	
	m.loginButton.translation = [m.rectWidth / 2 - m.loginButton.boundingRect().width / 2, 0]
	
	m.keyBox.width = getScreenSize().width
	m.keyBox.height = m.userKeyboard.boundingRect().height + 50
	m.keyBox.translation = [0, m.fullHeight]
	
	m.userKeyboard.textEditBox.voiceEnabled = true
	m.userKeyboard.translation = [ (m.keyBox.width - m.userKeyboard.boundingRect().width) / 2, (m.keyBox.height - m.userKeyboard.boundingRect().height) - 50 / 2 ]
	
	m.passKeyboard.textEditBox.voiceEnabled = true
	m.passKeyboard.translation = [ (m.keyBox.width - m.passKeyboard.boundingRect().width) / 2, (m.keyBox.height - m.passKeyboard.boundingRect().height) - 50 / 2 ]
	
    m.userTextEditBox.observeField("focusedChild", "onFocusChain")
    m.passTextEditBox.observeField("focusedChild", "onFocusChain")
	
    m.serverList.translation = [m.rectWidth / 2 - (m.fullWidth / 2.5) / 2 , 0]
	m.serverList.itemSize = [(m.fullWidth / 2.5), m.loginButton.boundingRect().height]
	m.serverList.observeField("itemSelected", "onServerSelected")
	
    m.userKeyboard.observeFieldScoped("continue", "doNext")
    m.userKeyboard.observeFieldScoped("left", "doLeft")
    m.userKeyboard.observeFieldScoped("right", "doRight")
    m.userKeyboard.observeField("focusedChild", "onFocusChain")
	
    m.passKeyboard.observeFieldScoped("continue", "doNext")
    m.passKeyboard.observeFieldScoped("left", "doLeft")
    m.passKeyboard.observeFieldScoped("right", "doRight")
    m.passKeyboard.observeField("focusedChild", "onFocusChain")
	
    m.loginButton.observeField("buttonSelected", "onValidateLogin") 
	m.userKeyboard.ObserveField("text", "OnKeyboardTextChanged")
	m.passKeyboard.ObserveField("text", "OnKeyboardTextChanged")

    m.validateLogin = createObject("roSGNode", "LoginTask")
    m.validateLogin.observeField("state", "validateLoginDone")
	
    m.currAddressPart = 0
	
    m.userTextEditBox.setFocus(true)
    'getUserData()
	m.checkServer = false
	
end sub

sub onServerSelected(event as Object)
	grid = event.GetRoSGNode()
	item = grid.content.GetChild(event.GetData())
	m.checkServer = true
    m.global.serverURL = item.url
	m.serverList.setFocus(false)
    m.loginButton.setFocus(true)
end sub

sub doLeft()
    if  m.userKeyboard.isInFocusChain() then
        m.userTextEditBox.cursorPosition = m.userTextEditBox.cursorPosition - 1
    elseif m.passKeyboard.isInFocusChain()
        m.passTextEditBox.cursorPosition = m.passTextEditBox.cursorPosition - 1
    end if
end sub

sub doRight()
    if  m.userKeyboard.isInFocusChain() then
        m.userTextEditBox.cursorPosition = m.userTextEditBox.cursorPosition + 1
    elseif m.passKeyboard.isInFocusChain()
        m.passTextEditBox.cursorPosition = m.userTextEditBox.cursorPosition + 1
    end if
end sub

sub doNext()
    m.currAddressPart = m.currAddressPart + 1
    updateAddressPart()
end sub

sub doPrev()
    m.currAddressPart = m.currAddressPart - 1
    updateAddressPart()
end sub

sub updateAddressPart()
    '?"Update Part ";m.currAddressPart
    if m.currAddressPart = 0
	    if  m.passKeyboard.isInFocusChain() and m.passKeyboard.visible then
			m.passTextEditBox.active = "false"
            m.passTextEditBox.setFocus(false)
            m.passKeyboard.setFocus(false)
            m.passKeyboard.visible = "false"
        end if
		m.userTextEditBox.setFocus(true)
        m.userKeyboard.setFocus(true)
        m.userKeyboard.visible = "true"
	    m.keyboard = m.userKeyboard
        m.keyboard.mode = "NameLower"
        m.stringToUpdate = m.userTextEditBox
        m.keyboard.domain = "alphanumeric"
    else if m.currAddressPart = 1
	    if  m.userKeyboard.isInFocusChain() and m.userKeyboard.visible then
		    m.userTextEditBox.active = "false"
		    m.userTextEditBox.setFocus(false)
            m.userKeyboard.setFocus(false)
            m.userKeyboard.visible = "false"
        elseif m.loginButton.isInFocusChain()
			m.loginButton.setFocus(false)   
        end if 
	    m.passTextEditBox.active = "true"
        m.passTextEditBox.setFocus(true)
        m.passKeyboard.setFocus(true)
        m.passKeyboard.visible = "true"
	    m.keyboard = m.passKeyboard
        m.keyboard.mode = "FullLower"
        m.stringToUpdate = m.passTextEditBox
        m.keyboard.domain = "alphanumeric"
    else if m.currAddressPart = 2
	    if  m.passKeyboard.isInFocusChain() and m.passKeyboard.visible then
            m.passKeyboard.setFocus(false)
            m.passKeyboard.visible = "false"
        end if
	    KeybordHide()
	    m.serverList.setFocus(true)
    else if m.currAddressPart = 3
	    m.serverList.setFocus(false)
		m.loginButton.setFocus(true)
    end if

    m.keyboard.text = m.stringToUpdate.text
    m.keyboard.textEditBox.cursorPosition = m.keyboard.text.Len()
    m.keyboard.keyGrid.jumpToKey = [ 0, 0, 0 ]
end sub

sub OnKeyboardTextChanged(event as Object)
	'? "TEXT CHANGED TO: "; event.GetData()
    if  m.userKeyboard.isInFocusChain() then
        m.userTextEditBox.text = event.GetData()
        cursorPosition = m.userTextEditBox.cursorPosition
        m.userTextEditBox.cursorPosition = cursorPosition + 1
    elseif m.passKeyboard.isInFocusChain()
	    m.passTextEditBox.text = event.GetData()
        cursorPosition = m.passTextEditBox.cursorPosition
        m.passTextEditBox.cursorPosition = cursorPosition + 1
    end if
end sub

function KeybordShow()
    'print "Show KEYBORD"
	updateAddressPart()
	m.LoginBox.translation = [m.fullWidth / 2 - m.rectWidth / 2, m.keyBox.height / 6]
	m.hideKey.keyValue = [[0,m.fullHeight],[0,(m.fullHeight - m.keyBox.height)]]
    m.hideAnimation.control = "start"
end function

function KeybordHide()
    'print "Hide KEYBORD"
	m.LoginBox.translation = [m.fullWidth / 2 - m.rectWidth / 2, m.fullHeight/2 - m.rectHeight/2]
	m.showKey.keyValue = [[0,(m.fullHeight - m.keyBox.height)],[0,m.fullHeight]]
    m.showAnimation.control = "start"
end function

sub onFocusChain()
    if  m.userTextEditBox.isInFocusChain() then
        m.userTextEditBox.active = "true"       
        m.userEditBox.uri = "pkg:/images/login/user-edit-focus.png"
        m.passEditBox.uri = "pkg:/images/login/pass-edit.png"
        m.userTextEditBox.hintTextColor = "#FFFFFF"
        m.userTextEditBox.textColor = "#FFFFFF"
    elseif m.passTextEditBox.isInFocusChain()
        m.passTextEditBox.active = "true"        
        m.passEditBox.uri = "pkg:/images/login/pass-edit-focus.png"
        m.userEditBox.uri = "pkg:/images/login/user-edit.png"
		m.passTextEditBox.hintTextColor = "#FFFFFF"
        m.passTextEditBox.textColor = "#FFFFFF"
        m.userTextEditBox.textColor = "#313233"
    elseif m.userKeyboard.isInFocusChain()
        m.userTextEditBox.text = m.userKeyboard.text
    elseif m.passKeyboard.isInFocusChain()
        m.passTextEditBox.text = m.passKeyboard.text
    else
        'm.label.color = "0xFFC300"
        m.userTextEditBox.hintTextColor = "#313233"
        m.userTextEditBox.textColor = "#313233"
        m.passTextEditBox.hintTextColor = "#313233"
        m.passTextEditBox.textColor = "#313233"
        m.passEditBox.uri = "pkg:/images/login/pass-edit.png"
        m.userEditBox.uri = "pkg:/images/login/user-edit.png"
    end if 

end sub

sub validateLoginDone()
    'print "in validateLoginDone"
    if m.validateLogin.state = "stop" then
        if m.validateLogin.validated then
            m.busyDialog.close = true 
            if m.validateLogin.validated then m.top.status = m.validateLogin.status
        else
			ShowMessageDialog( "Login Incorrect!", "Incorrect username or password" )
        end if 
    end if
end sub

sub onValidateLogin()
    'print "In ValidateLogin()";
	if m.userTextEditBox.text = "" or m.passTextEditBox.text = "" or not m.checkServer  then
	
	    if isEmpty(m.userTextEditBox.text) then
            title = "Cannot leave field empty"		
		    message = "Please enter a Username"
		elseif isEmpty(m.passTextEditBox.text) then 
            title = "Cannot leave field empty" 
		    message = "Please enter a Password"
		elseif not m.checkServer then 
            title = tr("Cannot leave field empty")
		    message = tr("Please you must select a Server")
		end if
	        ShowMessageDialog(title, message)
		
	else
        if not m.top.validate then
            m.top.validate = false
            m.validateLogin.user = m.userTextEditBox.text
            m.validateLogin.pass = m.passTextEditBox.text
            m.validateLogin.control = "RUN"
            m.busyDialog = createObject("roSGNode", "ProgressDialog")
            getScene().dialog = m.busyDialog
        end if
		
	end if
end sub

sub showExitButton()
    getScene().dialog.close = true
    if m.loginButton.isInFocusChain()
	    if isEmpty(m.userTextEditBox.text) then
            m.loginButton.setFocus(false)		
		    m.userTextEditBox.setFocus(true)
            m.userKeyboard.setFocus(true)
            m.userKeyboard.visible = "true"
			KeybordShow()
		elseif isEmpty(m.passTextEditBox.text) then
            m.loginButton.setFocus(false)		
			m.passTextEditBox.active = "true"
            m.passTextEditBox.setFocus(true)
            m.passKeyboard.setFocus(true)
            m.passKeyboard.visible = "true"
		    KeybordShow()
		elseif not m.checkServer then
            m.loginButton.setFocus(false)		
			m.serverList.setFocus(true)
		end if
	end if
end sub

function onKeyEvent(key as String, press as Boolean) as Boolean
  result = false
  if press then
    if key = "up"

        if m.loginButton.isInFocusChain()
			m.loginButton.setFocus(false)
			m.serverList.setFocus(true)
            '?"## login to password"
			result = true
        elseif m.passTextEditBox.isInFocusChain()
		    m.passTextEditBox.setFocus(false)
			m.passTextEditBox.active = "false"
            m.userTextEditBox.setFocus(true)
            '?"## password to user"
            result = true			
        elseif m.serverList.isInFocusChain()
            m.serverList.setFocus(false)
		    if m.serverList.itemSelected <> -1
			    m.serverList.jumpToItem = m.serverList.itemSelected
            end if	
			m.passTextEditBox.active = "true"
            m.passTextEditBox.setFocus(true)
            '?"## password to user" 
            result = true			
        end if 
		
    else if key = "down" 

        if  m.userTextEditBox.isInFocusChain() and not m.userKeyboard.isInFocusChain() then
			m.userTextEditBox.active = "false"
		    m.userTextEditBox.setFocus(false)
			m.passTextEditBox.active = "true"
            m.passTextEditBox.setFocus(true)
            '?"## user to password"
        elseif m.passTextEditBox.isInFocusChain()and not m.userKeyboard.isInFocusChain()
			m.passTextEditBox.active = "false"
			m.passTextEditBox.setFocus(false)
            m.serverList.setFocus(true)
            '?"## password to login"   
			result = true
        elseif m.serverList.isInFocusChain()
			m.serverList.setFocus(false)
            m.loginButton.setFocus(true)
		    if m.serverList.itemSelected <> -1
			    m.serverList.jumpToItem = m.serverList.itemSelected
            end if	
            '?"## password to login"
            result = true			
        end if 
		
    else if key = "back"
	
        if  m.userKeyboard.isInFocusChain() and m.userKeyboard.visible then
            m.userTextEditBox.setFocus(true)
		    KeybordHide()
            m.userKeyboard.visible = "false"
			result = true
        elseif m.passKeyboard.isInFocusChain() and m.passKeyboard.visible then
            m.passTextEditBox.setFocus(true)
            m.passKeyboard.visible = "false"
		    KeybordHide()
            result = true
        end if
			
    else if key = "OK"

	    result = true
        if  m.userTextEditBox.isInFocusChain() then
		    m.currAddressPart = 0
            m.userKeyboard.setFocus(true)
			KeybordShow()
            m.userKeyboard.visible = "true"
        elseif m.passTextEditBox.isInFocusChain()
		    m.currAddressPart = 1
            m.passKeyboard.setFocus(true)
            m.passKeyboard.visible = "true"
		    KeybordShow()	
        end if
			
    end if
  end if
  'print "Handled event: "; result
  return result
end function
