'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub Init()
	mBind(["markupGrid", "groupSection", "contentLabel"])
	getScene().FindNode("overhang").visible = false
    getScene().backgroundColor = getTheme().backgroundColor
    getScene().backgroundUri = "pkg:/images/overlay_darken.png"
	
    m.top.ObserveField("visible", "onVisibleChange")
	?"Width ";getScreenSize().width
	?"Height ";getScreenSize().height
	m.groupSection.translation = [(getScreenSize().width - 240) - m.contentLabel.boundingRect().height , 980]
	
end sub

sub OnVisibleChange() ' invoked when GridScreen change visibility
	m.markupGrid.content = invalid
    if m.top.visible = true
        rootChildren = []
        json = []
        json.Append(m.global.movie)
        json.Append(m.global.series)
        if json <> invalid and json.Count() > 0
            row = {}
            row.title = tr("My favorites")
            row.children = []
            for each item in json ' parse items and push them to row
                itemData = GetItemData(item)
                rootChildren.Push(itemData)
            end for
        end if  
        ' set up a root ContentNode to represent rowList on the GridScreen
        contentNode = CreateObject("roSGNode", "ContentNode")
        contentNode.Update({children: rootChildren}, true)
        m.top.content = contentNode
        m.markupGrid.SetFocus(true) ' set focus to rowList if GridScreen visible
    end if
end sub

function GetItemData(video as Object) as Object
    item = {}
	item.id = video.id
	item.title = video.title
	item.contentType = video.contentType
	item.mediaType = video.mediaType
    item.rating = video.rating
	item.hdPosterURL = video.hdPosterURL
	item.fhdposterurl = video.fhdposterurl
	
	if video.contentType = 1
        item.url = video.url
	else
		item.children = []
	end if
    return item
end function


