'*************************************************************
'** Roku Xtream-ALL for XoceUnder                            *
'** Copyright (c)2024 XoceUnder.  All rights reserved.       *
'*************************************************************
sub init()
    m.video = m.top.FindNode("video")
	m.title = m.top.FindNode("title")
	m.controlsGradient = m.top.FindNode("controlsGradient")
    m.loadingGroup = m.top.FindNode("loadingGroup")
    m.transportControls = m.top.FindNode("transportControls")
	m.LoadingBar = m.top.FindNode("LoadingBar")
    m.progressBar = m.top.FindNode("progressBar")
    m.stateIcon = m.top.FindNode("stateIcon")
    m.leftProgressLabel = m.top.FindNode("leftProgressLabel")
	m.rightProgressLabel = m.top.FindNode("rightProgressLabel")
    m.action = m.top.FindNode("action")
    ShowLoadingFacade(true)

	m.video.width = getScreenSize().width
	m.video.height = getScreenSize().height
	
    m.LoadingBar.translation = [getScreenSize().width/2 - 250/2, getScreenSize().height/2 + 250/2]
	
	m.transportControls.translation = [200, getScreenSize().width]
	
	m.controlsGradient.width = getScreenSize().width
	m.controlsGradient.height = getScreenSize().height
	
    ' animations
    m.showTCAnimation = m.top.findNode("showTCAnimation")
    m.transportControlsInterpolator = m.top.findNode("transportControlsInterpolator")
    m.gradientInterpolator = m.top.findNode("gradientInterpolator")
    ' controls hiding timer
    m.transportControlsTimer = m.top.findNode("transportControlsTimer")
    m.transportControlsTimer.ObserveFieldScoped("fire", "HideTransportControls")
    m.top.ObserveFieldScoped("focusedChild", "OnFocusChange")
	
    m.video.ObserveFieldScoped("state", "OnVideoStateChanged")
	m.video.observeField("position", "OnSavePosition")
    m.video.ObserveFieldScoped("duration", "OnDurationChanged")
    m.video.ObserveFieldScoped("progressPosition", "OnPositionChanged")
    m.video.ObserveFieldScoped("activeButton", "OnVideoButtonPressed")
	m.video.observeField("contentIndex", "onVideoChanged")

    m.fullTimeString = "0"
    m.screenHeight = getScreenSize().height
	
end sub

sub OnSavePosition()
    if int(m.video.position) MOD 2 = 0 and m.video.position > 10 then
        m.savePositionToReg = createObject("roSGNode", "WriteVideoPosition")
        m.savePositionToReg.section = "VideoPosition"
	    if m.video.content.GetChildCount() <> 0
		    ID = m.video.content.GetChild(0).id
		else
		    ID = m.video.content.id
		end if
        m.savePositionToReg.id = ID
        m.savePositionToReg.pos = m.video.position - 10
        m.savePositionToReg.control = "RUN"
    end if 
end sub

sub onVideoChanged()
    index = m.video.contentIndex
	if m.video.content.GetChildCount() <> 0
		title = m.video.content.GetChild(index).title
    else
		title = m.video.content.title
	end if
	    m.title.text = title
end sub

sub OnFocusChange()
    if m.top.HasFocus()
	    if m.video.content.GetChildCount() <> 0
		    title = m.video.content.GetChild(0).title
		else
		    title = m.video.content.title
		end if
	    m.title.text = title
        m.video.SetFocus(true)
    end if
end sub

sub ShowLoadingFacade(show as Boolean)
    m.loadingGroup.visible = show
end sub

sub OnVideoStateChanged(event as Object)
    state = event.GetData()
    if state = "buffering"
        ShowLoadingFacade(true)
    else if state = "playing"
	    ShowTransportControls()
        ShowLoadingFacade(false)
    end if
    if state = "paused"
        m.transportControlsTimer.control = "stop"
        SetStateIcon("pkg:/images/player/play.png")
    else
	    m.transportControlsTimer.control = "start"
        SetStateIcon("pkg:/images/player/pause.png")
    end if
    if state = "error" or state = "finished"
        dialog = createObject("roSGNode", "Dialog")
	    dialog.title = "Error Code"
	    dialog.optionsDialog = true
	    dialog.message = m.video.errorMsg
	    m.top.getscene().dialog = dialog
        ? "Video error code: ";m.video.errorCode
        ? "Video error message: ";m.video.errorMsg
        m.top.closeVideo = true
    else if state = "playing"
    end if
end sub

sub OnDurationChanged(event as Object)
    m.progressBar.length = event.GetData()
    m.fullTimeString = int(event.GetData())
    UpdateTimeLabel()
end sub

sub OnPositionChanged(event as Object)
    if m.direction = invalid
        m.progressBar.progressPosition = event.GetData()
        UpdateTimeLabel()
    end if
end sub

sub OnVideoButtonPressed(event as Object)
    button = event.GetData()
    ShowTransportControls()
    m.transportControlsTimer.control = "stop"
    if button = "right"
        m.action.uri = "pkg:/images/player/plus10.png"
    else if button = "left"
        m.action.uri = "pkg:/images/player/minus10.png"
    else if button = "fastforward"
        m.action.uri = "pkg:/images/player/ff" + m.video.FFRewCount.ToStr() + ".png"
    else if button = "rewind"
        m.action.uri = "pkg:/images/player/rewind" + m.video.FFRewCount.ToStr() + ".png"
    else if button = "down"
        m.action.uri = ""
        m.transportControlsTimer.control = "start"
    else if button = ""
        m.action.uri = ""
        m.transportControlsTimer.control = "start"
    end if
end sub

sub UpdateTimeLabel()
    leftPositionSeconds = int(m.progressBar.progressPosition) * 100 / 100
    rightPositionSeconds = evalInteger(m.fullTimeString) - leftPositionSeconds
    m.leftProgressLabel.text = GetDurationStringStandard(leftPositionSeconds)
	m.progressBar.translation = [(m.leftProgressLabel.translation[0] + 20) + m.leftProgressLabel.boundingRect().width,4]
    m.rightProgressLabel.text = GetDurationStringStandard(rightPositionSeconds)
	if m.leftProgressLabel.boundingRect().width > m.rightProgressLabel.boundingRect().width
	    m.progressBar.width = (1270 - (m.leftProgressLabel.boundingRect().width - m.rightProgressLabel.boundingRect().width))
	else 
		m.progressBar.width = 1270
	end if
end sub

sub SetStateIcon(uri as String)
    m.stateIcon.uri = uri
end sub

sub OnTransportControlsShow(slideUp as Boolean)
    if slideUp
        m.transportControlsInterpolator.keyValue = [m.transportControls.translation, [0, m.screenHeight*0.9]]
        m.gradientInterpolator.keyValue = [m.transportControls.opacity, 1.0]
    else
        m.transportControlsInterpolator.keyValue = [m.transportControls.translation, [0, m.screenHeight]]
        m.gradientInterpolator.keyValue = [m.transportControls.opacity, 0.0]
    end if
    m.showTCAnimation.control = "start"
end sub

sub HideTransportControls()
    OnTransportControlsShow(false)
end sub

sub ShowTransportControls()
    OnTransportControlsShow(true)
end sub

function OnKeyEvent(key as String, press as Boolean) as Boolean
    if press and key = "back" and m.transportControls.opacity > 0
        HideTransportControls()
        return true
	else if key = "OK"
	    'ShowTransportControls()
    end if
    return false
end function
