'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
Sub init()
    mBind(["settingLabel", "menu", "title", "message", "checklist", "MainMenu", "pinWidget", "MainInfo", "titlePin", "bottomPin", "delete", "radiolist"])
	
	'getScene().FindNode("overhang").visible = false
    getScene().backgroundColor = getTheme().backgroundColor
    getScene().backgroundUri = "pkg:/images/backgrounds/background_settings.jpg"

	m.settingLabel.text = tr("Parental Control")
	m.focused_menu_item = -1
	
    ' create buttons
    button = []
	if regread("lock", ReadManifest().title) = "0000"
        button.push({title : tr("Change Pin"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/lock_open.png", description : tr("Change your pin to protect your adult content and settings.")})
    else
        button.push({title : tr("Change Pin"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/lock_close.png", description : tr("Change your pin to protect your adult content and settings.")})
	end if	
    button.push({title : tr("Hide Channels Categories"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/hide_icon.png", description : tr("Select all the categories you want to protect with a security code to control adult content.")})
    button.push({title : tr("Hide Movies Categories"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/hide_icon.png", description : tr("Select all the categories you want to protect with a security code to control adult content.")})
    button.push({title : tr("Hide Series Categories"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/hide_icon.png", description : tr("Select all the categories you want to protect with a security code to control adult content.")})
    button.push({title : tr("Sort Content List"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/sort.png", description : tr("Sort content list to improve content display.")})
    button.push({title : tr("Stream Format"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/format-live.png", description : tr("Broadcast format for live channels.")})		
	button.push({title : tr("Remove Account From Device"), "list_selection": "pkg:/images/list_selection.png", "list_selection_focus": "pkg:/images/list_selection_focus.png", icon: "pkg:/images/icons/unlink.png", description : tr("Remove account from this device This will wipe all data from this device related to this account.")})
    
    parentContent = createObject("roSgNode", "contentNode")

    for each item in button 
        childContent = parentContent.createChild("listFields")
        childContent.title = item.title
        childContent.list_selection = item.list_selection
        childContent.list_selection_focus = item.list_selection_focus
        childContent.icon = item.icon
        childContent.description = item.description
    end for
	
	m.menu.content = parentContent
	
	m.MainMenu.height = m.menu.boundingRect().height + 100
    centerY = (getScreenSize().height - m.MainMenu.height) / 2
    m.MainMenu.translation = [ 105 , centerY ]
	m.MainInfo.translation = [ getScreenSize().width / 2 , (getScreenSize().height - m.MainInfo.height) / 2 ]
	
	m.title.translation = [ (m.MainInfo.boundingRect().width - m.title.width) / 2 , 20 ]
	
	m.message.translation = [ (m.MainInfo.boundingRect().width - m.message.width) / 2 , 700 ]
	
	m.titlePin.translation = [ (m.MainInfo.boundingRect().width - m.titlePin.boundingRect().width) / 2 , 150 ]
	m.pinWidget.translation = [ (m.MainInfo.boundingRect().width - m.pinWidget.boundingRect().width) / 2 , 220 ]
	m.delete.translation = [ (m.MainInfo.boundingRect().width - m.delete.boundingRect().width) / 2 , 220 ]
	m.bottomPin.translation = [ (m.MainInfo.boundingRect().width - m.bottomPin.boundingRect().width) / 2 , 700 ]
	
	m.checklist.translation = [ m.MainInfo.boundingRect().width / 4  , 130 ]
	m.radiolist.translation = [ m.MainInfo.boundingRect().width / 4  , 130 ]
	
    m.menu.observeField("itemSelected", "on_menu_item_selected")
    m.menu.observeField("itemFocused", "on_menu_item_focused")
    m.checklist.observeField("checkedState", "on_checked_state_update")
	m.radiolist.observeField("checkedItem", "on_checked_Item_update")
	
    m.category = CreateObject("roSGNode", "CategorylistTask")
	m.category.ObserveField("finish", "OnCategorylist")
    m.category.control = "run"
	
	m.menu.setFocus(true)
	
End Sub

' Handle menu item focus
function OnCategorylist(event as object) as void
	list = event.GetRoSGNode()
	m.top.setField("channelCategory", list.live)
	m.top.setField("moviesCategory", list.movies)
	m.top.setField("seriesCategory", list.series)
end function

' Handle menu item selected
function on_menu_item_selected(event as object) as void
    select_menu_item(event.getData())
end function

' Handle menu item focus
function on_menu_item_focused(event as object) as void
    focus_menu_item(event.getData())
end function

' Select a menu item
function select_menu_item(item as integer) as void
    ' Parental
    if item = 0
        m.pinwidget.setFocus(true)
		m.titlePin.text = tr("Enter Current Pin")
		if regread("lock", ReadManifest().title) = "0000" then m.bottomPin.text = tr("Default pin is 0000 to change")
    ' Hide Live
    else if item = 1
        m.checklist.setFocus(true)
    ' Hide movies
    else if item = 2
        m.checklist.setFocus(true)
    ' Hide Series
    else if item = 3
        m.checklist.setFocus(true)
    ' Sort
    else if item = 4
        m.radiolist.setFocus(true)
    ' Stream Format
    else if item = 5
        m.radiolist.setFocus(true)
    ' Remove
    else if item = 6
        m.look = createObject("roSGNode", "PinDialog")
        m.look.title = tr("Enter Pin")
        m.look.pinPad.secureMode  = false
        m.look.pinPad.pinLength   = "4"
		if regread("lock", ReadManifest().title) = "0000" then m.look.message = tr("Default pin is 0000 to change it in account settings")
        m.look.buttons = [tr("OK")]
        m.look.observeField("buttonSelected","onVerifyRemoveAccount")
        m.look.setFocus(true)
	    getScene().dialog = m.look
    ' Unhandled
    else
        print "Unhandled setting menu item selected: " + item.toStr()
    end if
end function


' Focus a menu item
function focus_menu_item(item as integer) as void
    reset()
	content = m.menu.content.GetChild(item)
    m.focused_menu_item = item
    ' Parental
    if item = 0
        m.title.text = content.title
        m.message.text = content.description
		m.titlePin.text = tr("Enter Current Pin")
		m.pinwidget.visible = true
		if regread("lock", ReadManifest().title) = "0000" then m.bottomPin.text = tr("Default pin is 0000 to change")
    ' Hide Live
    else if item = 1
        checked_state = []
        ' Set title
        m.title.text = content.title
        m.message.text = content.description
        ' Clear content
        m.checklist.content.removeChildrenIndex(m.checklist.content.getChildCount(), 0)
        ' Add items
        for each lang_item in m.top.channelCategory
            lang_enabled = false
			if m.global.channelCategory <> invalid
			    for each code in m.global.channelCategory
                    if lang_item.code = code
                        lang_enabled = true
                    end if
                end for
			end if	
            checked_state.push(lang_enabled)
            ' Add code to checklist
            check_item = m.checklist.content.createChild("ContentNode")
            name = clean(lang_item.name)
            check_item.title = name
            check_item.hideicon = false
        end for
        ' Set checklist state
        m.checklist.checkedState = checked_state
        m.checklist.visible = true
    ' Hide Movies
    else if item = 2
        checked_state = []
        ' Set title
        m.title.text = content.title
        m.message.text = content.description
        ' Clear content
        m.checklist.content.removeChildrenIndex(m.checklist.content.getChildCount(), 0)
        ' Add lang items
        for each lang_item in m.top.moviesCategory
            lang_enabled = false
			if m.global.moviesCategory <> invalid
                for each lang in m.global.moviesCategory
                    if lang_item.code = lang
                        lang_enabled = true
                    end if
                end for
			end if
            checked_state.push(lang_enabled)
            ' Add lang to checklist
            check_item = m.checklist.content.createChild("ContentNode")
            name = clean(lang_item.name)
            check_item.title = name
            check_item.hideicon = false
        end for
        ' Set checklist state
        m.checklist.checkedState = checked_state
        m.checklist.visible = true
    ' Hide Series
    else if item = 3
        checked_state = []
        ' Set title
        m.title.text = content.title
        m.message.text = content.description
        ' Clear content
        m.checklist.content.removeChildrenIndex(m.checklist.content.getChildCount(), 0)
        ' Add lang items
        for each lang_item in m.top.seriesCategory
            lang_enabled = false
			if m.global.seriesCategory <> invalid
                for each lang in m.global.seriesCategory
                    if lang_item.code = lang
                        lang_enabled = true
                    end if
                end for
			end if
            checked_state.push(lang_enabled)
            ' Add lang to checklist
            check_item = m.checklist.content.createChild("ContentNode")
            name = clean(lang_item.name)
            check_item.title = name
            check_item.hideicon = false
        end for
        ' Set checklist state
        m.checklist.checkedState = checked_state
        m.checklist.visible = true
    ' Sort
    else if item = 4
        ' Set title
        m.title.text = content.title
        m.message.text = content.description
        ' Clear content
        m.radiolist.content.removeChildrenIndex(m.radiolist.content.getChildCount(), 0)
        ' Add sort items
        items = []
        items.push( { code : "auto" , "title": "Automatic" } )
        items.push( { code : "name" , "title": "Sort by alphabet" } )
        items.push( { code : "id" , "title": "Sort by last" } )
        for each sort in items
            radio_item = m.radiolist.content.createChild("ContentNode")
            radio_item.title = tr(sort.title)
        end for
        ' Set selected item
        if m.global.sort = "auto"
            m.radiolist.checkedItem = 0
        else
            for sort = 0 to items.count() - 1
                if m.global.sort = items[sort].code
                    m.radiolist.checkedItem = sort
                end if
            end for
        end if
        ' Show sort list
        m.radiolist.visible = true
    ' Stream Format
    else if item = 5
        ' Set title
        m.title.text = content.title
        m.message.text = content.description
        ' Clear content
        m.radiolist.content.removeChildrenIndex(m.radiolist.content.getChildCount(), 0)
        ' Add format items
        items = []
        items.push( { code : "hls" , "title": "M3u8 Streaming" } )
        items.push( { code : "ism" , "title": "Smooth Streaming" } )

        for each format in items
            radio_item = m.radiolist.content.createChild("ContentNode")
            radio_item.title = tr(format.title)
        end for
        ' Set selected item
        if m.global.streamFormat = "hls"
            m.radiolist.checkedItem = 0
        else
            for format = 0 to items.count() - 1
                if m.global.streamFormat = items[format].code
                    m.radiolist.checkedItem = format
                end if
            end for
        end if
        ' Show format list
        m.radiolist.visible = true
    ' Remove
    else if item = 6
        m.title.text = content.title
        m.message.text = content.description
		m.delete.visible = true
    ' Unhandled
    else
        print "Unhandled setting menu item focused: " + item.toStr()
    end if
end function

' Reset the title and message
function reset() as void
    m.title.text = ""
    m.message.text = ""
	m.titlePin.text = ""
	m.bottomPin.text = ""
	m.bottomPin.color = "#FFFFFF"
	m.pinwidget.visible = false
    m.checklist.visible = false
	m.radiolist.visible = false
	m.delete.visible = false
    m.focused_menu_item = -1
end function

' Handle checklist checked state change
function on_checked_state_update() as void
    if m.focused_menu_item = 1
        json = m.top.channelCategory
		code_global = m.global.channelCategory
    else if m.focused_menu_item = 2
        json = m.top.moviesCategory
		code_global = m.global.moviesCategory
    else if m.focused_menu_item = 3
        json = m.top.seriesCategory
		code_global = m.global.seriesCategory
    end if
    if json.count() <> m.checklist.checkedState.count()
        return
    end if
    ' Check if all was selected prior to modification
    all_selected = false
    for each code in code_global
        if code = "all"
            all_selected = true
        end if
    end for
    ' Initialize the counter
    trueCount = 0
    ' selects assets on array elements
    for each item in m.checklist.checkedState
        if item = true then
            trueCount += 1
        end if
    end for
    ' Uncheck others if all is selected
    if m.checklist.checkedState[0] and not all_selected
		'm.focused = false
        checkedState = [true]
        for index = 1 to json.count() - 1
            checkedState[index] = false
        end for
        m.checklist.checkedState = checkedState
    else if all_selected and trueCount <> 1
        checkedState = m.checklist.checkedState
        checkedState[0] = false
        m.checklist.checkedState = checkedState
    else if all_selected
        checkedState = m.checklist.checkedState
        m.checklist.checkedState = checkedState
    end if
    ' Create list of enabled
    category = []
    for index = 0 to json.count() - 1
        if m.checklist.checkedState[index]
            category.push(json[index].code)
        end if
    end for
    if m.focused_menu_item = 1 and m.checklist.hasFocus()
        m.global.channelCategory = category
		regWrite("channelCategory", FormatJSON(category), ReadManifest().title)
    else if m.focused_menu_item = 2 and m.checklist.hasFocus()
        m.global.moviesCategory = category
		regWrite("moviesCategory", FormatJSON(category), ReadManifest().title)
    else if m.focused_menu_item = 3 and m.checklist.hasFocus()
        m.global.seriesCategory = category
		regWrite("seriesCategory", FormatJSON(category), ReadManifest().title)
    end if
end function

' Handle radiolist checked item change
function on_checked_item_update(event as object) as void
    if m.focused_menu_item = 4
        if event.getData() = 0
			m.global.sort = "auto"
			regWrite("sort", "auto", ReadManifest().title)
        else if event.getData() = 1
			m.global.sort = "name"
			regWrite("sort", "name", ReadManifest().title)
        else if event.getData() = 2
			m.global.sort = "id"
			regWrite("sort", "id", ReadManifest().title)
        end if
    else if m.focused_menu_item = 5
        if event.getData() = 0
			m.global.streamFormat = "hls"
			regWrite("streamFormat", "hls", ReadManifest().title)
        else if event.getData() = 1
			m.global.streamFormat = "ism"
			regWrite("streamFormat", "ism", ReadManifest().title)
        end if
    end if
end function

sub onVerifyRemoveAccount()
	if m.look.buttonSelected = 0 and m.look.pin.len() = 4 then
       'print "ok button pressed"
        m.confirmPin = createObject("roSGNode", "PinTask")
        m.confirmPin.section = ReadManifest().title
        m.confirmPin.pin = m.look.pin
        m.confirmPin.observeField("state","removeAccount")
        m.confirmPin.control = "RUN"
    end if
end sub

sub removeAccount()
    if m.confirmPin.state = "stop" then 
        if m.confirmPin.result then
		    regDelete("userTV", ReadManifest().title)
            regDelete("passTV", ReadManifest().title)
		    regDelete("channelCategory", ReadManifest().title)
			regDelete("moviesCategory", ReadManifest().title)
			regDelete("seriesCategory", ReadManifest().title)
		    regDelete("live", ReadManifest().title)
			regDelete("movie", ReadManifest().title)
			regDelete("series", ReadManifest().title)
			regDelete("sort", ReadManifest().title)
			regDelete("streamFormat", ReadManifest().title)
            regDelete("serverDNS", ReadManifest().title)	
            regDelete("lock", ReadManifest().title)	
		   getScene().close = true
        else
            m.look.title = tr("Incorrect Pin, try again")
            m.look.pin = ""
			m.look.setFocus(true)
        end if
    end if
end sub

' Handle keys
function onKeyEvent(key as string, press as boolean) as boolean
    ' Checklist / Radiolist
    if m.checklist.hasFocus() or m.radiolist.hasFocus()
        ' Set main settings menu focus
        if press and (key = "left" or key = "back")
            m.menu.setFocus(true)
            return true
        end if
    ' Menu
    else if m.menu.hasFocus()
        ' Activate
        if press and key = "right"
            if m.menu.itemFocused = 0
			    m.pinWidget.setFocus(true)
                return true
            else if m.menu.itemFocused = 1
                m.checklist.setFocus(true)
                return true
            else if m.menu.itemFocused = 2
                m.checklist.setFocus(true)
                return true
            else if m.menu.itemFocused = 3
                m.checklist.setFocus(true)
                return true
            else if m.menu.itemFocused = 4
                m.radiolist.setFocus(true)
                return true
            else if m.menu.itemFocused = 5
                m.radiolist.setFocus(true)
                return true
            else if m.menu.itemFocused = 6
                m.look = createObject("roSGNode", "PinDialog")
                m.look.title = tr("Enter Pin")
                m.look.pinPad.secureMode  = false
                m.look.pinPad.pinLength   = "4"
                if regread("lock", ReadManifest().title) = "0000" then m.look.message = tr("Default pin is 0000 to change it in account settings")
                m.look.buttons = [tr("OK")]
                m.look.observeField("buttonSelected","onVerifyRemoveAccount")
                m.look.setFocus(true)
                getScene().dialog = m.look
                return true
            end if
        end if
	else if (m.pinWidget.visible = true) and (m.menu.hasFocus() = false)	
        ' Activate
        if press and key = "left"
            if m.menu.itemFocused = 0
			    m.menu.setFocus(true)
                return true
            end if
        end if
    end if
    return false
end function
