'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub Init()
    m.top.functionName = "GetContent"
    if m.global.contentType = "live"
        m.category = m.global.channelCategory 
    else if m.global.contentType = "movie"
        m.category = m.global.moviesCategory 
    else if m.global.contentType = "series"
        m.category =  m.global.seriesCategory
    end if
end sub

sub GetContent()
    content = createObject("roSGNode", "ContentNode")
    ' request the content feed from the API
    http = NewHttp( m.global.serverURL + "/player_api.php?username=" + m.global.user +"&password=" + m.global.pass + "&action=" + m.global.action)
    rsp = http.GetToStringWithRetry()
    json = ParseJson(rsp)
	if json <> invalid and json.Count() > 0
	    result = []
		if m.global.contentType = "live"
		    result = [{"category_id": "0","category_name": "My Favorites","parent_id": 0}]
		end if
		result.Append(json)
        for i = 0 to result.count()-1
		    look_enabled = false
			if m.category <> invalid
                for each look in m.category
                    if look = "all"
					    look_enabled = true
                    else if result[i].category_id = look
                        look_enabled = true
                    end if
                end for
			end if
		    itemcontent = content.createChild("ContentNode")
		    itemcontent.id = result[i].category_id
		    itemcontent.hdgridposterurl = "pkg:/images/icons/movie.png"
		    itemcontent.title = clean(tr(result[i].category_name))
		    itemcontent.addField("duration", "float", false)
		    itemcontent.setField("duration", "0.0"+ stri(i+1))
		    itemcontent.addFields({look: look_enabled})
        end for
	end if
    m.top.content = content
end sub
