' ********** Copyright 2020 Roku Corp.  All Rights Reserved. **********

' Note that we need to import this file in MainLoaderTask.xml using relative path.
sub Init()
    ' set the name of the function in the Task node component to be executed when the state field changes to RUN
    ' in our case this method executed after the following cmd: m.contentTask.control = "run"(see Init method in MainScene)
    m.top.functionName = "GetContent"
end sub

sub GetContent()
    ' request the content feed from the API
	rootChildren = []
    json = []
    json.Append(m.global.movie)
    json.Append(m.global.series)
	if json <> invalid and json.Count() > 0
        row = {}
        row.title = ("My Favorites")
        row.children = []
        for each item in json ' parse items and push them to row
            itemData = GetItemData(item)
            rootChildren.Push(itemData)
        end for
	end if  
    ' set up a root ContentNode to represent rowList on the GridScreen
    contentNode = CreateObject("roSGNode", "ContentNode")
    contentNode.Update({children: rootChildren}, true)
	m.top.content = contentNode
end sub

function GetItemData(video as Object) as Object
    item = {}
	item.id = video.id
	item.title = video.title
	item.contentType = video.contentType
	item.mediaType = video.mediaType
    item.rating = video.rating
	item.hdPosterURL = video.hdPosterURL
	item.fhdposterurl = video.fhdposterurl
	
	if video.contentType = 1
        item.url = video.url
	else
		item.children = []
	end if
	
    return item
end function