'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub Init()
    m.top.functionName = "GetContent"
end sub

sub GetContent()
    ' request the content feed from the API
	if not isArray(m.global.cachesearch)
	    ?"No Cache"
        http = NewHttp( m.global.serverURL + "/player_api.php?username=" + m.global.user +"&password=" + m.global.pass + "&action=" + m.top.action )
        rsp = http.GetToStringWithRetry()
	    m.global.cachesearch = ParseJson(rsp)
		json = ParseJson(rsp)
	else
	    ?"Si Cache"
	    json = m.global.cachesearch
	end if
    rootChildren = []
    if json <> invalid and json.Count() > 0
	    if m.global.sort <> "auto"
            if json[0].stream_id <> invalid
	    	    if m.global.sort = "id"
                    json.SortBy("stream_id", "r")
	    		else
	    		    json.SortBy("name")
	    		end if
            else
	    	    if m.global.sort = "id"
                    json.SortBy("series_id", "r")
	    		else
		    	    json.SortBy("name")
		    	end if
            end if
		end if
            row = {}
            row.title = tr("Result:")
            row.children = []
            for each item in json ' parse items and push them to row
                itemData = GetItemData(item)
                if (LCase(itemData.title).Instr(LCase(m.top.searchTerm)) > -1)
                    row.children.Push(itemData)
                end if
            end for
			rootChildren.Push(row)
    end if  
    ' set up a root ContentNode to represent rowList on the GridScreen
    contentNode = CreateObject("roSGNode", "ContentNode")
    contentNode.Update({children: rootChildren}, true)
	m.top.content = contentNode
end sub

function GetItemData(video as Object) as Object
    item = {}
	item.title = video.name
	item.contentType = m.global.contentType
	item.mediaType = m.global.contentType
    item.rating = AnyToString(video.rating)
    item.description = ""
	item.categories = ""
	item.actors = ""
	item.cast = ""
    item.releasedate = ""
	item.directors = ""
    item.length = ""
    item.duration = ""
	
	if m.global.contentType = "live"
		item.id = video.stream_id
		item.hdPosterURL = video.stream_icon
		m3u8 = ".m3u8"
		if m.global.streamFormat <> "hls" m3u8 = ".ts"
        item.url = m.global.serverURL + m.global.play + tostr(video.stream_id) + m3u8
		item.live = true
		item.fhdposterurl = ""
	else if m.global.contentType = "movie"
		item.id = video.stream_id
		item.hdPosterURL = video.stream_icon
        item.url = m.global.serverURL + m.global.play + tostr(video.stream_id) + "." + video.container_extension
		item.fhdposterurl = ""
	else if m.global.contentType = "series"
		item.id = video.series_id
		item.hdPosterURL = video.cover
		item.fhdposterurl = backdrop_path(video.backdrop_path)
		item.children = []
	end if

    return item
end function