'*************************************************************
'** Roku Xtream-ALL for XoceUnder                            *
'** Copyright (c)2024 XoceUnder.  All rights reserved.       *
'*************************************************************
sub Init()
    m.top.functionName = "GetContent"
end sub

sub GetContent()
    if m.top.id <> "0"
    	' request the content feed from the API
    	http = NewHttp( m.global.serverURL + "/player_api.php?username=" + m.global.user +"&password=" + m.global.pass + "&action=" + m.global.items +"&category_id=" + m.top.id)
    	rsp = http.GetToStringWithRetry()
    	json = ParseJson(rsp)
		m.content = createObject("RoSGNode","ContentNode")
		if json <> invalid and json.Count() > 0 then
			if m.global.sort <> "auto"
        		if m.global.sort = "id"
            		json.SortBy("stream_id", "r")
        		else
					json.SortBy("name")
				end if
        	end if
        	for each channel in json
				m.channel = m.content.createChild("ContentNode")
				m.channel.id = channel.stream_id
        		m.channel.title = channel.name.ToStr()
				if isnonemptystr(channel.stream_icon) and channel.stream_icon <> invalid  then
        		   m.channel.hdposterurl = channel.stream_icon
				else 
        		   m.channel.hdposterurl = "pkg:/images/channel.png"
        		end if		
				m3u8 = ".m3u8"
				if m.global.streamFormat <> "hls" m3u8 = ".ts"
        		m.channel.url = m.global.serverURL + m.global.play + tostr(channel.stream_id) + m3u8
        		m.channel.live = true
        		'm.channel.streamFormat = "hls"
				m.channel.addFields({"nowTime": getCurrentTime()})
				'if channel.program <> invalid
        		'    for each program in channel.program 
				'        addProgram(program)
        		'    end for
				'end if
       	 	end for
    	end if
		m.top.content = m.content
	else
    	json = m.global.live
		m.content = createObject("RoSGNode","ContentNode")
		if json <> invalid and json.Count() > 0 then
			if m.global.sort <> "auto"
        		if m.global.sort = "id"
            		json.SortBy("id", "r")
        		else
					json.SortBy("title")
				end if
        	end if
        	for each channel in json
				m.channel = m.content.createChild("ContentNode")
				m.channel.id = channel.id
        		m.channel.title = channel.title.ToStr()
				if isnonemptystr(channel.hdposterurl) and channel.hdposterurl <> invalid  then
        		   m.channel.hdposterurl = channel.hdposterurl
				else 
        		   m.channel.hdposterurl = "pkg:/images/channel.png"
        		end if		
				m3u8 = ".m3u8"
				if m.global.streamFormat <> "hls" m3u8 = ".ts"
        		m.channel.url = m.global.serverURL + m.global.play + tostr(channel.id) + m3u8
        		m.channel.live = true
				m.channel.addFields({"nowTime": getCurrentTime()})
       	 	end for
        else		
			m.channel = m.content.createChild("ContentNode")
			m.channel.id = "0"
        	m.channel.title = tr("Empty")
            m.channel.hdposterurl = "pkg:/images/channel.png"
			m3u8 = ".m3u8"
			if m.global.streamFormat <> "hls" m3u8 = ".ts"
        	m.channel.url = m.global.serverURL + m.global.play + tostr("0") + m3u8
        	m.channel.live = true
			m.channel.addFields({"nowTime": getCurrentTime()})
    	end if
		m.top.content = m.content
	end if
end sub

sub addProgram(program as Object) as Object
     item = m.channel.createChild("ContentNode")
     item.title = program.program_title
     item.playDuration = program.duration
     item.playStart = program.start_timestamp
	 item.description = program.description
end sub

