'*************************************************************
'** Roku Xtream-ALL for XoceUnder                            *
'** Copyright (c)2024 XoceUnder.  All rights reserved.       *
'*************************************************************
sub Init()
    ' set the name of the function in the Task node component to be executed when the state field changes to RUN
    ' in our case this method executed after the following cmd: m.contentTask.control = "run"(see Init method in MainScene)
    m.top.functionName = "GetContent"
end sub

sub GetContent()
    ' request the content feed from the API
    http = NewHttp( m.global.serverURL + "/player_api.php?username=" + m.global.user +"&password=" + m.global.pass + "&action=get_vod_info&vod_id="+ m.top.id )
    rsp = http.GetToStringWithRetry()
    json = ParseJson(rsp)
	if json <> invalid and json.Count() > 0
        itemData = GetInfoData(json)
		m.top.content.update(itemData,false)
	end if 
	m.top.contentView = m.top.content
end sub

function GetInfoData(video as Object) as Object
    item = {}
	if video.description <> invalid
        item.description = video.info.description
    else
        item.description = video.info.plot
    end if
	item.categories = video.info.genre
	item.actors = video.info.actors
	item.cast = video.info.cast
    item.releasedate = video.info.releasedate
	item.directors = video.info.director
    item.length = video.info.duration_secs
    item.duration = video.info.duration
    item.fhdposterurl = backdrop_path(video.info.backdrop_path)
    return item
end function
