'*************************************************************
'** Roku Xtream-ALL for XoceUnder
'** Copyright (c)2024 XoceUnder.  All rights reserved.
sub Main(args as dynamic)
    screen = CreateObject("roSGScreen")
    m.port = CreateObject("roMessagePort")
    screen.SetMessagePort(m.port)
    if args.DoesExist("mediaType") and args.DoesExist("contentID")	then
		scene = screen.CreateScene("DeepLinkScene")
		scene.launchArgs = args
	else
        scene = screen.CreateScene("MainScene")
    end if
    m.global = screen.getGlobalNode()
    initGlobals()
    screen.Show()
	scene.observeField("close", m.port)
    scene.signalBeacon("AppDialogInitiate")
    scene.signalBeacon("AppDialogComplete")
    scene.signalBeacon("AppLaunchComplete")

    while(true)
        msg = wait(0, m.port)
        msgType = type(msg)
		Dbg("msg.getNode(): ", msg.getNode())
		Dbg("msg.getField(): ", msg.getField())
        if msgType = "roSGNodeEvent"
		    node = msg.getField()
			Dbg("roSGNodeEvent ", node)
            if node = "close" and msg.getData()
                return
            end if
        else if msgType = "roDeviceInfoEvent"
            info = msg.GetInfo()
			Dbg("roDeviceInfoEvent ", info)
        else if msgType = "roInputEvent"
            if msg.IsInput()
                info = msg.GetInfo()
            end if
        else if msgType = "roVideoPlayerEvent" 
		    Dbg("Audio tracks available.", msg.GetInfo())
            'tracks = player.getAudioTracks()
            'print tracks.count(); " audio tracks available."
        end if
    end while
end sub

function initGlobals()

	m.global.AddField("theme", "assocarray", true)
	m.global.setField("theme", theme())
    m.global.AddField("GetModel", "string", true)
	m.global.setField("getModel", GetModel())
    m.global.AddField("rokuUniqueID", "string", true)
    m.global.setField("rokuUniqueID", getDeviceESN())
    m.global.AddField("user", "string", true)
    m.global.AddField("pass", "string", true)
    m.global.AddField("expire", "string", true)
	m.global.AddField("email", "string", true)
    m.global.AddField("max_connections", "string", true)
    m.global.AddField("active_cons", "string", true)
	m.global.AddField("contentType", "string", true)
	m.global.AddField("action", "string", true)
	m.global.AddField("items", "string", true)
	m.global.AddField("play", "string", true)
	m.global.AddField("isAdult", "bool", true)
	m.global.AddField("backdrop", "string", true)
	m.global.AddField("isExitApp", "bool", true)
	m.global.AddField("showMenu", "bool", true)
	m.global.AddField("contentTask", "node", true)
	m.global.AddField("titleSection", "string", true)
	m.global.AddField("channelCategory", "array", true)
	m.global.AddField("live", "array", true)
	m.global.AddField("moviesCategory", "array", true)
	m.global.AddField("movie", "array", true)
	m.global.AddField("seriesCategory", "array", true)
	m.global.AddField("series", "array", true)
	m.global.AddField("sort", "string", true)
	m.global.AddField("streamFormat", "string", true)
	m.global.AddField("timeServer", "integer", true)
	m.global.channelCategory = LoadArraySection("channelCategory", ReadManifest().title)
    m.global.moviesCategory = LoadArraySection("moviesCategory", ReadManifest().title)
    m.global.seriesCategory = LoadArraySection("seriesCategory", ReadManifest().title)
    m.global.live = LoadArrayMyList("live", ReadManifest().title)
	m.global.movie = LoadArrayMyList("movie", ReadManifest().title)
	m.global.series = LoadArrayMyList("series", ReadManifest().title)
	m.global.sort = regread("sort", ReadManifest().title)
	m.global.streamFormat = regread("streamFormat", ReadManifest().title)
    m.global.AddField("cacheSearch", "array", true)
    m.global.AddField("serverURL", "string", true)
	m.global.serverURL = regread("serverDNS", ReadManifest().title)
	
end function
